// DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo.h"
#include "DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
	m_insetbevelbtn = 0;
	m_orientationbtn = 3;
	m_outerbevelbtn = 1;
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
	DDX_Control(pDX, IDC_SLIDER3, m_outerbevel);
	DDX_Control(pDX, IDC_SLIDER2, m_innerbevel);
	DDX_Control(pDX, IDC_SLIDER1, m_border);
	DDX_Control(pDX, IDC_POSLABEL, m_poslabel);
	DDX_Control(pDX, 1011, m_knob);
	DDX_Radio(pDX, IDC_RADIO1, m_insetbevelbtn);
	DDX_Radio(pDX, IDC_RADIO4, m_orientationbtn);
	DDX_Radio(pDX, IDC_RADIO8, m_outerbevelbtn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO1, OnRadio1)
	ON_BN_CLICKED(IDC_RADIO2, OnRadio2)
	ON_BN_CLICKED(IDC_RADIO3, OnRadio3)
	ON_BN_CLICKED(IDC_RADIO4, OnRadio4)
	ON_BN_CLICKED(IDC_RADIO5, OnRadio5)
	ON_BN_CLICKED(IDC_RADIO6, OnRadio6)
	ON_BN_CLICKED(IDC_RADIO7, OnRadio7)
	ON_BN_CLICKED(IDC_RADIO8, OnRadio8)
	ON_BN_CLICKED(IDC_RADIO9, OnRadio9)
	ON_BN_CLICKED(IDC_RADIO10, OnRadio10)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

BOOL CDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_outerbevel.SetRange(0, 10, TRUE);
	m_innerbevel.SetRange(0, 10, TRUE);
	m_border.SetRange(0, 30, TRUE);

	m_outerbevel.SetPageSize(1);
	m_innerbevel.SetPageSize(1);
	m_border.SetPageSize(1);

	m_outerbevel.SetPos(2);
	m_innerbevel.SetPos(2);
	m_border.SetPos(3);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BEGIN_EVENTSINK_MAP(CDemoDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CDemoDlg)
	ON_EVENT(CDemoDlg, 1011, 1 /* ValueChanged */, OnValueChangedKnob, VTS_PI2)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CDemoDlg::OnValueChangedKnob(short FAR* Pos) 
{
	CString temp;
	temp.Format("%d", *Pos);
	m_poslabel.SetWindowText(temp);
}

void CDemoDlg::OnRadio1() 
{
	UpdateData();
	m_knob.SetInnerBevel(m_insetbevelbtn);
}

void CDemoDlg::OnRadio2() 
{
	OnRadio1();
}

void CDemoDlg::OnRadio3() 
{
	OnRadio1();
}

void CDemoDlg::OnRadio4() 
{
	UpdateData();
	m_knob.SetOrientation(m_orientationbtn);
}

void CDemoDlg::OnRadio5() 
{
	OnRadio4();
}

void CDemoDlg::OnRadio6() 
{
	OnRadio4();
}

void CDemoDlg::OnRadio7() 
{
	OnRadio4();
}

void CDemoDlg::OnRadio8() 
{
	UpdateData();
	m_knob.SetOuterBevel(m_outerbevelbtn);	
}

void CDemoDlg::OnRadio9() 
{
	OnRadio8();
}

void CDemoDlg::OnRadio10() 
{
	OnRadio8();
}

void CDemoDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (SB_ENDSCROLL == nSBCode)
	{
		if (&m_outerbevel == (CSliderCtrl *)pScrollBar)
		{
			m_knob.SetOuterBevelWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else if (&m_innerbevel == (CSliderCtrl *)pScrollBar)
		{
			m_knob.SetInnerBevelWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else if (&m_border == (CSliderCtrl *)pScrollBar)
		{
			m_knob.SetBorderWidth(((CSliderCtrl *)pScrollBar)->GetPos());
		}
		else
		{
			m_knob.SetPos(((CSliderCtrl *)pScrollBar)->GetPos());
		}
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);

}
